/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.fluent.collections.views;

import com.floragunn.fluent.collections.UnmodifiableIterator;
import com.floragunn.fluent.collections.views.IteratorView;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;

public class IteratorViewImpl {
    static <E> UnmodifiableIterator<E> filter(final Iterator<E> iter, final Predicate<E> predicate) {
        final E first = IteratorViewImpl.firstMatching(iter, predicate);
        if (first == null) {
            return UnmodifiableIterator.empty();
        }
        return new UnmodifiableIterator<E>(){
            E e;
            {
                this.e = first;
            }

            @Override
            public boolean hasNext() {
                return this.e != null;
            }

            @Override
            public E next() {
                Object result = this.e;
                Object next = null;
                while (iter.hasNext() && next == null) {
                    Object candidate = iter.next();
                    if (!predicate.test(candidate)) continue;
                    next = candidate;
                    break;
                }
                this.e = next;
                return result;
            }
        };
    }

    static <ES, ET> IteratorView<ET> map(Iterator<ES> iterator, Function<ES, ET> valueMappingFunction) {
        return new ValueRewritingIteratorView<ES, ET>(iterator, valueMappingFunction);
    }

    static <E> E firstMatching(Iterator<E> iter, Predicate<E> predicate) {
        while (iter.hasNext()) {
            E e = iter.next();
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    static class ValueRewritingIteratorView<ES, ET>
    implements IteratorView<ET> {
        private final Iterator<ES> source;
        private final Function<ES, ET> valueMappingFunction;

        public ValueRewritingIteratorView(Iterator<ES> source, Function<ES, ET> valueMappingFunction) {
            this.source = source;
            this.valueMappingFunction = valueMappingFunction;
        }

        @Override
        public boolean hasNext() {
            return this.source.hasNext();
        }

        @Override
        public ET next() {
            return this.valueMappingFunction.apply(this.source.next());
        }
    }
}

